<!-- new Task -->
<div class="modal fade modal--shadow" id="new-task" role="dialog" tabindex="-1" wire:ignore>
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body py-0 px-0">

                
                <header class="modal--header px-4">
                    <h5 class="mb-0 fw-bold text-white">New Task</h5>
                    <button class="btn btn--raw-icon w-auto" data-bs-toggle="tooltip" data-bss-tooltip=""
                        data-bs-placement="right" data-bs-dismiss="modal" type="button" title="Close Modal">
                        <svg class="bi bi-dash-lg fs-1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                            fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M2 8a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11A.5.5 0 0 1 2 8Z">
                            </path>
                        </svg>
                    </button>
                </header>
                





                


                
                <form class="px-4" wire:submit='store' wire:loading.class='disabled' wire:target='store, translate'>
                    <div class="row row pt-2 align-items-center mb-4">

                        
                        <div class="col-4">
                            <label class="form-label form--label">Created By</label>
                            <input class="form-control form--input readonly mb-4" type="text"
                                value="<?php echo e(session('userName')); ?>" readonly="" />
                        </div>






                        
                        <div class="col-4">
                            <label class="form-label form--label">Assigned To</label>
                            <div class="select--single-wrapper mb-4">
                                <select class="form-select form--select2 init--modal-select"
                                    data-formItem='formData.taskHandlerId' data-modal='#new-task' required>
                                    <option value=""></option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            </div>
                        </div>







                        
                        <div class="col-4">
                            <label class="form-label form--label">Followed By</label>
                            <div class="select--single-wrapper mb-4">
                                <select class="form-select form--select2 init--modal-select"
                                    data-formItem='formData.taskFollowerId' data-modal='#new-task' required>
                                    <option value=""></option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            </div>
                        </div>






                        
                        <div class="col-4">
                            <label class="form-label form--label">Creation Date</label>
                            <div class="input--icon scalebellmix--4">
                                <svg class="bi bi-calendar4-week" xmlns="http://www.w3.org/2000/svg" width="1em"
                                    height="1em" fill="currentColor" viewBox="0 0 16 16">
                                    <path
                                        d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM2 2a1 1 0 0 0-1 1v1h14V3a1 1 0 0 0-1-1H2zm13 3H1v9a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V5z">
                                    </path>
                                    <path
                                        d="M11 7.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1zm-3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1zm-2 3a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1zm-3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1z">
                                    </path>
                                </svg>
                                <input class="form-control form--input mb-4 input--bg readonly fs-12" type="date"
                                    value="<?php echo e(date('Y-m-d')); ?>" readonly="" />
                            </div>
                        </div>













                        
                        <div class="col-4">
                            <label class="form-label form--label">Execution Date</label>
                            <input class="form-control form--input mb-4" type="date"
                                wire:model.live='formData.taskExecutionDate' required />
                        </div>

                        
                        <div class="col-4">
                            <label class="form-label form--label">Due Date</label>
                            <input class="form-control form--input mb-4" type="date"
                                wire:model.live='formData.taskDueDate' required />
                        </div>






                        
                        <div class="col-12">
                            <label class="form-label form--label">Task Description</label>
                            <input class="form-control form--input mb-4" type="text"
                                wire:change="translate('taskDescAr', 'taskDesc', 'en')"
                                wire:model.live='formData.taskDescAr' required />
                        </div>


                        
                        <div class="col-12">
                            <label class="form-label form--label">Task Description in English</label>
                            <input class="form-control form--input mb-4" type="text"
                                wire:change="translate('taskDesc', 'taskDescAr', 'ar')"
                                wire:model.live='formData.taskDesc' required />
                        </div>



                        
                        <div class="col-12 text-end mt-2">

                            
                            <span class="spinner-border spinner-border-sm text-success" role="status" wire:loading
                                wire:target='store, translate'></span>



                            <button
                                class="btn btn--scheme btn--scheme-theme px-5 py-1 d-inline-flex align-items-center mx-1 scale--self-05"
                                type="submit" wire:loading.attr='disabled' wire:target='store, translate'>
                                Assign Task
                            </button>
                        </div>


                    </div>
                </form>
                
            </div>
        </div>
    </div>
    







    
    



    <script>
        // 1: select2 changeEvent
      $(".init--modal-select").on("change", function(event) {


         // 1.1: getValue - formDataItem
         selectValue = $(this).select2('val');
         formItem = $(this).attr('data-formItem');

         window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(formItem, selectValue);

      }); //end function
    </script>


    
    








</div>
<?php /**PATH C:\xampp\htdocs\TRUTH\LFM\LFM10\resources\views/livewire/dashboard/executions/single-execution/components/execution-create-task.blade.php ENDPATH**/ ?>