
<div>


    
    <div class="row" wire:ignore>


        
        <div class="col">
            <label class="form-label form--label">Court</label>
            <div class="select--single-wrapper mb-4">
                <select class="form-select form--select2 init--select" data-formItem='courtId'>
                    <option value=""></option>
                    <!-- __BLOCK__ --><?php $__currentLoopData = $courts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $court): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($court->id); ?>"><?php echo e($court->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
                </select>
            </div>
        </div>



        
        <div class="col">
            <label class="form-label form--label">Pleading Lawyer</label>
            <div class="select--single-wrapper mb-4">
                <select class="form-select form--select2 init--select" data-formItem='pleadingLawyerId'>
                    <option value=""></option>
                    <!-- __BLOCK__ --><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
                </select>
            </div>
        </div>




        
        <div class="col">
            <label class="form-label form--label">Client</label>
            <div class="select--single-wrapper mb-4">
                <select class="form-select form--select2 init--select" data-formItem='clientId'>
                    <option value=""></option>
                    <!-- __BLOCK__ --><?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
                </select>
            </div>
        </div>


        
        <div class="col">
            <label class="form-label form--label">From Date</label>
            <input wire:model.live.debounce.100ms='fromDate' class="form-control form--input mb-4" type="date" />
        </div>


        
        <div class="col">
            <label class="form-label form--label">Until Date</label>
            <input wire:model.live.debounce.100ms='untilDate' class="form-control form--input mb-4" type="date" />
        </div>
    </div>
    








    







    
    <div class="row row pt-2 align-items-center mb-4">

        
        <div class="col-3"></div>



        
        <div class="col-6 text-center">
            <h4 class="mb-0 fw-bold text-solid-black">Hearing Schedule</h4>
        </div>


        
        <div class="col-3 text-end">
            <h3 data-bs-toggle="tooltip" data-bss-tooltip=""
                class="fw-bold text-white scale--self-05 d-inline-block badge--theme px-3 rounded-1 mb-0 py-1"
                title="Number of Hearings"><?php echo e($fileCases->count()); ?></h3>
        </div>





        
        




        
        <div class="col-12 mt-4">
            <div class="table-responsive memoir--table w-100" id="hearings--table">
                <table class="table table-bordered" id="hearings--table">

                    
                    <thead>
                        <tr>
                            <th class="th--xs">File</th>
                            <th class="th--xs">Case</th>
                            <th class="th--md">Case Type</th>
                            <th class="th--md">Client</th>
                            <th class="th--sm">Client Title</th>
                            <th class="th--md">Opponents</th>
                            <th class="th--sm">Last Hearing</th>
                            <th class="th--lg">Last Hearing Verdict</th>
                        </tr>
                    </thead>



                    
                    <tbody>


                        
                        <!-- __BLOCK__ --><?php $__currentLoopData = $fileCases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fileCase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <tr>

                            
                            <td class="fw-bold"><?php echo e($fileCase->file->serial); ?></td>
                            <td class="fw-bold"><?php echo e($fileCase->caseNumber); ?></td>
                            <td><?php echo e($fileCase->caseType->name); ?></td>

                            <td class="scale--3"><?php echo e($fileCase->client->name); ?></td>
                            <td><?php echo e($fileCase->clientTitle->title); ?></td>



                            
                            <td class="scale--3">
                                <p class='mb-0 pointer text-decoration-underline' data-bs-toggle="tooltip"
                                    data-bs-html='true' data-bss-tooltip=""
                                    title="<?php echo e($fileCase->opponentsInString() ? $fileCase->opponentsInString() : 'No Opponents'); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" fill="currentColor"
                                        viewBox="0 0 16 16" class="bi bi-info-circle fs-6 me-2"
                                        style="fill: var(--delete-color)">
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z">
                                        </path>
                                        <path
                                            d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533L8.93 6.588zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0z">
                                        </path>
                                    </svg>Hover To View
                                </p>
                            </td>




                            
                            <td>
                                <?php echo e($fileCase->hearings->last() ? date('d/m/Y',
                                strtotime($fileCase->hearings->last()->hearingDate)) : ''); ?>

                            </td>


                            
                            <td class="text-start">
                                <p class="truncate-text-4l h-100 mb-0 expand--paragraph truncate-text-4l pointer scale--3"
                                    data-table="hearing" data-id="1"><i class="far fa-eye me-2 ms-1 fs-14"
                                        data-table="hearing"
                                        data-id="<?php echo e($fileCase->hearings->last() ? $fileCase->hearings->last()->id : ''); ?>"
                                        style=" color: var(--color-scheme-dark-3);"></i><?php echo e($fileCase?->verdicts->last()?->courtDecision); ?>

                                </p>
                            </td>
                        </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
                        

                    </tbody>
                    

                </table>
            </div>
        </div>
    </div>
    











    
    



    <script>
        // 1: select2 changeEvent
        $(".init--select").on("change", function (event) {


            // 1.1: getValue - formDataItem
            selectValue = event.target.value;
            formItem = $(this).attr('data-formItem');

            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(formItem, selectValue);

        }); //end function

    </script>


    
    






</div>
<?php /**PATH C:\xampp\htdocs\TRUTH\LFM\LFM10\resources\views/livewire/dashboard/reports/components/reports-view-hearings.blade.php ENDPATH**/ ?>