<!-- new Operation -->
<div class="modal fade modal--shadow" id="operation-invoices" role="dialog" tabindex="-1" wire:ignore.self>
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body px-4 rtl--direction">



                
                <form wire:submit='store' wire:loading.class='disabled'
                    wire:target='update, translate, instance.documentFile'>
                    <div class="row pt-2 align-items-center mb-3">




                        
                        <div class="col-3"></div>







                        
                        <div class="col-6 text-center">
                            <h4 class="mb-0 badge--theme text-white px-4 rounded-1 py-1 d-inline-block fs-5">
                                <?php echo e(__('Operation Invoices')); ?>

                            </h4>
                        </div>





                        
                        <div class="col-3 text-end">
                            <button class="btn btn--raw-icon w-auto btn--close" data-bs-toggle="tooltip"
                                data-bss-tooltip="" data-bs-placement="<?php echo e(__('right')); ?>" data-bs-dismiss="modal"
                                type="button" title="<?php echo e(__('Close Modal')); ?>">
                                <svg class="bi bi-dash-lg fs-2" xmlns="http://www.w3.org/2000/svg" width="1em"
                                    height="1em" fill="currentColor" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd"
                                        d="M2 8a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11A.5.5 0 0 1 2 8Z">
                                    </path>
                                </svg>
                            </button>
                        </div>
                    </div>


                    






                    
                    








                    
                    <div class="row pt-2 align-items-center mb-4">







                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Invoice Date')); ?></label>
                            <input class="form-control form--input  mb-4" type="date" wire:model='instance.invoiceDate'
                                required />
                        </div>





                        
                        <div class="col-4"></div>






                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Invoice Amount')); ?></label>
                            <input class="form-control form--input  mb-4" type="text" data-type='number'
                                pattern='[0-9\.,]+' wire:model='instance.invoiceAmount' required />
                        </div>











                        
                        








                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Title')); ?></label>
                            <input class="form-control form--input  mb-4" type="text" required
                                wire:change="translate('titleAr', 'title', 'en')" wire:model='instance.titleAr' />
                        </div>





                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Title in English')); ?></label>
                            <input class="form-control form--input  mb-4" type="text" required
                                wire:change="translate('title', 'titleAr', 'ar')" wire:model='instance.title' />
                        </div>







                        
                        <div class="col-4">
                            <label class="form-label form--label"><?php echo e(__('Invoice File')); ?></label>

                            <input class="form-control form--file-input mb-4" id='invoice--file-1' type="file" required
                                wire:model='instance.documentFile' />
                        </div>









                        
                        








                        
                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Note')); ?></label>
                            <input class="form-control form--input  mb-4" type="text"
                                wire:change="translate('noteAr', 'note', 'en')" wire:model='instance.noteAr' />
                        </div>





                        <div class="col-6">
                            <label class="form-label form--label"><?php echo e(__('Note in English')); ?></label>
                            <input class="form-control form--input  mb-4" type="text"
                                wire:change="translate('note', 'noteAr', 'ar')" wire:model='instance.note' />
                        </div>








                        
                        








                        
                        <div class="col-12 text-center mt-2 position-relative">



                            
                            <span class="spinner-border spinner-border-sm text-success spinner--float-right"
                                role="status" wire:loading
                                wire:target='update, translate, instance.documentFile'></span>


                            
                            <button
                                class="btn btn--scheme btn--scheme-3 px-5 scalemix--3 py-1 d-inline-flex align-items-center mx-1 scale--self-05"
                                type="submit" wire:loading.attr='disabled'
                                wire:target='update, translate, instance.documentFile'>
                                <?php echo e(__('Save')); ?></button>


                        </div>
                    </div>
                </form>
                







                
                









                
                <div>
                    <div class="row pt-2 align-items-center mb-3">



                        
                        <div class="col-12 mt-1 mb-4">
                            <div class="table-responsive memoir--table">
                                <table class="table table-bordered">




                                    
                                    <thead>

                                        <tr>
                                            <th class='th--lg'><?php echo e(__('Title')); ?></th>
                                            <th class='th--md'><?php echo e(__('Date')); ?></th>
                                            <th class='th--sm'><?php echo e(__('Amount')); ?></th>

                                            <th class='th--md'></th>
                                            <th class='th--xs'></th>
                                        </tr>

                                    </thead>
                                    








                                    
                                    






                                    
                                    <tbody>



                                        
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $invoices ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                        <tr key='single-operation-invoice-<?php echo e($invoice->id); ?>'>






                                            
                                            <td><?php echo e($invoice?->{__('title')}); ?></td>


                                            
                                            <td dir='ltr'><?php echo e(date('d / m / Y', strtotime($invoice->invoiceDate))); ?>

                                            </td>





                                            
                                            <td><?php echo e($invoice?->invoiceAmount ?? 0); ?></td>






                                            
                                            <td>


                                                
                                                <!--[if BLOCK]><![endif]--><?php if($invoice->documentFile): ?>



                                                <button wire:loading.attr='disabled' wire:target='remove, download'
                                                    wire:click='download(<?php echo e($invoice->id); ?>)'
                                                    class="btn btn--scheme btn--scheme-3 fs-12 mx-1 scale--3 px-2 py-1"
                                                    type="button">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                                        fill="currentColor" viewBox="0 0 16 16"
                                                        class="bi bi-save fs-6 me-2">
                                                        <path
                                                            d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9.5a1 1 0 0 0-1 1v7.293l2.646-2.647a.5.5 0 0 1 .708.708l-3.5 3.5a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L7.5 9.293V2a2 2 0 0 1 2-2H14a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h2.5a.5.5 0 0 1 0 1H2z">
                                                        </path>
                                                    </svg><?php echo e(__('Download')); ?>

                                                </button>






                                                
                                                <?php else: ?>

                                                <button disabled
                                                    class="btn btn--scheme btn--scheme-3 fs-12 mx-1 scale--3 px-2 py-1"
                                                    type="button">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                                        fill="currentColor" viewBox="0 0 16 16"
                                                        class="bi bi-save fs-6 me-2">
                                                        <path
                                                            d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H9.5a1 1 0 0 0-1 1v7.293l2.646-2.647a.5.5 0 0 1 .708.708l-3.5 3.5a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L7.5 9.293V2a2 2 0 0 1 2-2H14a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h2.5a.5.5 0 0 1 0 1H2z">
                                                        </path>
                                                    </svg><?php echo e(__('Download File')); ?>

                                                </button>


                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                




                                            </td>





                                            
                                            








                                            
                                            <td>


                                                
                                                <button wire:loading.attr='disabled' wire:target='remove, download'
                                                    wire:click='remove(<?php echo e($invoice->id); ?>)'
                                                    class="btn btn--scheme btn--remove fs-12  scale--3 px-2 py-1"
                                                    type="button">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                                                        fill="currentColor" viewBox="0 0 16 16"
                                                        class="bi bi-trash fs-6 ">
                                                        <path
                                                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z">
                                                        </path>
                                                        <path fill-rule="evenodd"
                                                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z">
                                                        </path>
                                                    </svg>
                                                </button>

                                            </td>
                                            



                                        </tr>


                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        





                                    </tbody>
                                </table>
                            </div>
                        </div>
                        

                    </div>
                </div>
                







            </div>
        </div>
    </div>
    

















    
    





    
    <script>
        $(".init--modal-invoice-select").on("change", function(event) {


         // 1.1: getValue - instanceItem
         selectValue = $(this).select2('val');
         instance = $(this).attr('data-instance');

         window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(instance, selectValue);

      }); //end function
    </script>






    
    













</div>
<?php /**PATH C:\xampp_\htdocs\TRUTH\LFM\resources\views/livewire/dashboard/report-files/single-report-file/components/single-report-file-operations-invoices.blade.php ENDPATH**/ ?>