<!-- new document -->
<div class="modal fade modal--shadow" id="new-document" role="dialog" tabindex="-1" wire:ignore>
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body py-0 px-0">


                
                <header class="modal--header px-4">
                    <h5 class="mb-0 fw-bold text-white">New Document</h5>
                    <button class="btn btn--raw-icon w-auto" data-bs-toggle="tooltip" data-bss-tooltip=""
                        data-bs-placement="right" data-bs-dismiss="modal" type="button" title="Close Modal">
                        <svg class="bi bi-dash-lg fs-1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"
                            fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M2 8a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11A.5.5 0 0 1 2 8Z">
                            </path>
                        </svg>
                    </button>
                </header>




                
                <form class="px-4" wire:submit='store' wire:loading.class='disabled'
                    wire:target='store, documentFile, translate'>
                    <div class="row row pt-2 align-items-center mb-4">


                        
                        <div class="col-4">
                            <label class="form-label form--label">Created By</label>
                            <input class="form-control form--input readonly mb-4" type="text"
                                value="<?php echo e(session('userName')); ?>" readonly="" />
                        </div>


                        
                        <div class="col-4"></div>


                        
                        <div class="col-4">
                            <label class="form-label form--label">Document Type</label>
                            <div class="select--single-wrapper mb-4">
                                <select class="form-select form--select2 init--modal-select"
                                    data-formItem='formData.documentTypeId' data-modal='#new-document' required>
                                    <option value=""></option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $documentTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $documentType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($documentType->id); ?>"><?php echo e($documentType->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            </div>
                        </div>



                        
                        <div class="col-4">
                            <label class="form-label form--label">Creation Date</label>
                            <div class="input--icon scalebellmix--4">
                                <svg class="bi bi-calendar4-week" xmlns="http://www.w3.org/2000/svg" width="1em"
                                    height="1em" fill="currentColor" viewBox="0 0 16 16">
                                    <path
                                        d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM2 2a1 1 0 0 0-1 1v1h14V3a1 1 0 0 0-1-1H2zm13 3H1v9a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V5z">
                                    </path>
                                    <path
                                        d="M11 7.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1zm-3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1zm-2 3a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1zm-3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1z">
                                    </path>
                                </svg>
                                <input class="form-control form--input mb-4 input--bg readonly " type="date"
                                    value="<?php echo e(date('Y-m-d')); ?>" readonly="" />
                            </div>
                        </div>





                        
                        <div class="col-4">
                            <label class="form-label form--label">Document Title</label>
                            <input class="form-control form--input mb-4 " type="text"
                                wire:change="translate('documentNameAr', 'documentName', 'en')"
                                wire:model.live='formData.documentNameAr' required />
                        </div>

                        <div class="col-4">
                            <label class="form-label form--label">Document Title in English</label>
                            <input class="form-control form--input mb-4 " type="text"
                                wire:change="translate('documentName', 'documentNameAr', 'ar')"
                                wire:model.live='formData.documentName' required />
                        </div>




                        
                        <div class="col-6">
                            <label class="form-label form--label">Notes</label>
                            <input class="form-control form--input mb-4 " type="text"
                                wire:change="translate('documentInformationAr', 'documentInformation', 'en')"
                                wire:model.live='formData.documentInformationAr' />
                        </div>

                        <div class="col-6">
                            <label class="form-label form--label">Notes in English</label>
                            <input class="form-control form--input mb-4 " type="text"
                                wire:change="translate('documentInformation', 'documentInformationAr', 'ar')"
                                wire:model.live='formData.documentInformation' />
                        </div>



                        
                        <div class="col-12">
                            <label class="form-label form--label">Attachment File</label>
                            <input class="form-control form--file-input mb-4" id='caseDocumentFile' type="file"
                                wire:model.live='documentFile' required />
                        </div>



                        
                        <div class="col-12 text-end mt-2">

                            
                            <span class="spinner-border spinner-border-sm text-success" role="status" wire:loading
                                wire:target='store, documentFile, translate'></span>



                            <button
                                class="btn btn--scheme btn--scheme-theme px-5 py-1 d-inline-flex align-items-center mx-1 scale--self-05"
                                type="submit" wire:loading.attr='disabled' wire:target='store, documentFile, translate'>
                                Save
                            </button>
                        </div>

                    </div>
                </form>
                
            </div>
        </div>
    </div>
    







    
    



    <script>
        // 1: select2 changeEvent
      $(".init--modal-select").on("change", function(event) {


         // 1.1: getValue - formDataItem
         selectValue = $(this).select2('val');
         formItem = $(this).attr('data-formItem');

         window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(formItem, selectValue);

      }); //end function
    </script>


    
    







</div>
<?php /**PATH C:\xampp\htdocs\TRUTH\LFM\LFM10\resources\views/livewire/dashboard/executions/single-execution/components/execution-create-document.blade.php ENDPATH**/ ?>