
<div>


    
    <div class="row" wire:ignore>




        
        <div class="col">
            <label class="form-label form--label"><?php echo e(__('Court')); ?></label>
            <div class="select--single-wrapper mb-4">
                <select class="form-select form--select2 init--select init--hearing-select" data-instance='searchCourt'
                    data-clear='true'>
                    <option value=""></option>

                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $courts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $court): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <option value="<?php echo e($court->id); ?>"><?php echo e($court?->{__('name')}); ?></option>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
            </div>
        </div>








        
        <div class="col">
            <label class="form-label form--label"><?php echo e(__('Pleading Lawyer')); ?></label>
            <div class="select--single-wrapper mb-4">
                <select class="form-select form--select2 init--select init--hearing-select"
                    data-instance='searchPleadingLawyer' data-clear='true'>
                    <option value=""></option>

                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $users ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>"><?php echo e($user?->{__('name')}); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                </select>
            </div>
        </div>







        
        <div class="col">
            <label class="form-label form--label"><?php echo e(__('Client')); ?></label>
            <div class="select--single-wrapper mb-4">
                <select class="form-select form--select2 init--select init--hearing-select" data-instance='searchClient'
                    data-clear='true'>
                    <option value=""></option>

                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $clients ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($client->id); ?>"><?php echo e($client?->{__('name')}); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                </select>
            </div>
        </div>






        
        <div class="col">
            <label class="form-label form--label"><?php echo e(__('From Date')); ?></label>
            <input wire:model.live='searchFromDate' class="form-control form--input mb-4" type="date" />
        </div>







        
        <div class="col">
            <label class="form-label form--label"><?php echo e(__('Until Date')); ?></label>
            <input wire:model.live='searchUntilDate' class="form-control form--input mb-4" type="date" />
        </div>




    </div>
    









    
    










    
    <div class="row row pt-2 align-items-center mb-4">



        
        <div class="col-3"></div>



        
        <div class="col-6 text-center">
            <h4 class="mb-0 fw-bold text-solid-black"><?php echo e(__('Hearing Schedule')); ?></h4>
        </div>




        
        <div class="col-3 text-end">
            <h3 data-bs-toggle="tooltip" data-bss-tooltip=""
                class="fw-bold text-white scale--self-05 d-inline-block badge--theme px-3 rounded-1 mb-0 py-1"
                title="<?php echo e(__('Number of Hearings')); ?>"><?php echo e($fileCases?->total()); ?></h3>
        </div>







        
        








        
        <div class="col-12 mt-4">
            <div class="table-responsive memoir--table w-100" id="hearings--table">
                <table class="table table-bordered" id="hearings--table">




                    
                    <thead>
                        <tr>
                            <th class="th--xs"><?php echo e(__('File')); ?></th>
                            <th class="th--xs"><?php echo e(__('Case')); ?></th>
                            <th class="th--md"><?php echo e(__('Case Type')); ?></th>
                            <th class="th--md"><?php echo e(__('Client')); ?></th>
                            <th class="th--sm"><?php echo e(__('Client Title')); ?></th>
                            <th class="th--md"><?php echo e(__('Opponents')); ?></th>
                            <th class="th--sm"><?php echo e(__('Last Hearing')); ?></th>
                            <th class="th--lg"><?php echo e(__('Last Hearing Verdict')); ?></th>
                        </tr>
                    </thead>
                    






                    
                    






                    
                    <tbody>


                        
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $fileCases ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fileCase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <tr key='hearing-tr-<?php echo e($fileCase->id); ?>'>




                            
                            <td class="fw-bold"><?php echo e($fileCase?->file?->serial); ?></td>
                            <td class="fw-bold"><?php echo e($fileCase?->caseNumber); ?></td>
                            <td><?php echo e($fileCase?->caseType?->{__('name')}); ?>

                            </td>








                            
                            <td class="scale--3"><?php echo e($fileCase?->client?->{__('name')}); ?></td>



                            
                            <td><?php echo e($fileCase?->clientTitle?->{__('title')}); ?></td>






                            
                            








                            
                            <td class="scale--3">
                                <p class='mb-0 pointer text-decoration-underline' data-bs-toggle="tooltip"
                                    data-bs-html='true' data-bss-tooltip="" title="<?php echo e($fileCase?->opponentsInString() ?
                                     $fileCase?->opponentsInString() : __('No Opponents')); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" fill="currentColor"
                                        viewBox="0 0 16 16" class="bi bi-info-circle fs-6 me-2"
                                        style="fill: var(--delete-color)">
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z">
                                        </path>
                                        <path
                                            d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533L8.93 6.588zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0z">
                                        </path>
                                    </svg><?php echo e(__('Hover To View')); ?>

                                </p>
                            </td>






                            
                            






                            
                            <td>
                                <?php echo e($fileCase?->hearings?->last() ? date('d / m / Y',
                                strtotime($fileCase?->hearings?->last()?->hearingDate)) : ''); ?>

                            </td>








                            
                            <td class="text-start">
                                <p class="truncate-text-4l h-100 mb-0 expand--paragraph truncate-text-4l pointer scale--3"
                                    data-table="hearing" data-id="1"><i class="far fa-eye me-2 ms-1 fs-14"
                                        data-table="hearing" data-id="<?php echo e($fileCase?->hearings?->last() ?
                                         $fileCase?->hearings?->last()?->id : ''); ?>"
                                        style="color: var(--color-scheme-dark-3);"></i><?php echo e($fileCase?->verdicts?->last()?->{__('courtDecision')}); ?>

                                </p>
                            </td>
                        </tr>


                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        



                    </tbody>
                </table>
                



            </div>
        </div>
    </div>
    

















    
    










    
    <script>
        $(".init--hearing-select").on("change", function (event) {


            // 1.1: getValue - instance
            selectValue = $(this).select2('val');
            instance = $(this).attr('data-instance');

            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(instance, selectValue);

        }); //end function

    </script>






    
    










</div>
<?php /**PATH C:\xampp_\htdocs\TRUTH\LFM\resources\views/livewire/dashboard/records/components/records-hearings.blade.php ENDPATH**/ ?>